/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

public class ParticleEffectLoader
extends SynchronousAssetLoader<ParticleEffect, ParticleEffectParameter> {
    public ParticleEffectLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public ParticleEffect load(AssetManager am, String fileName, FileHandle file, ParticleEffectParameter param2) {
        ParticleEffect effect = new ParticleEffect();
        if (param2 != null && param2.atlasFile != null) {
            effect.load(file, am.get(param2.atlasFile, TextureAtlas.class), param2.atlasPrefix);
        } else if (param2 != null && param2.imagesDir != null) {
            effect.load(file, param2.imagesDir);
        } else {
            effect.load(file, file.parent());
        }
        return effect;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ParticleEffectParameter param2) {
        Array<AssetDescriptor<TextureAtlas>> deps = null;
        if (param2 != null && param2.atlasFile != null) {
            deps = new Array<AssetDescriptor<TextureAtlas>>();
            deps.add(new AssetDescriptor<TextureAtlas>(param2.atlasFile, TextureAtlas.class));
        }
        return deps;
    }

    public static class ParticleEffectParameter
    extends AssetLoaderParameters<ParticleEffect> {
        public String atlasFile;
        public String atlasPrefix;
        public FileHandle imagesDir;
    }
}

